;;; cdr255-keyboards.el --- Library for dealing with keyboard layouts  -*- lexical-binding: t; -*-

;; Copyright (C) 2025 Claire Rodriguez

;; Author: Claire Rodriguez <yewscion@gmail.com>
;; Keywords: lisp, tools
;; Version: 0.0.4

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;; 

;;; Code:

(require 'cdr255)

(defconst +cdr-keyboards:ansi100-layout-format-string+
  (concat
   "                                            ANSI100 Layout - %s layer"
   "\n\n ┌────┬────┬────┬────┬────┬────┬────┬────┬────┬────┬────┬────┬───"
   "─┬────┬────┐    ┌────┬────┬────┬────┐\n │ %s │ %s │ %s │ %s │ %s "
   "│ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │    │ %s"
   " │ %s │ %s │ %s │\n │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s" ;
   " │ %s │ %s │ %s │ %s │ %s │ %s │ %s │    │ %s │ %s │ %s │ %s"
   " │\n └────┴────┴────┴────┴────┴────┴────┴────┴────┴────┴────┴────┴────"
   "┴────┴────┘    └────┴────┴────┴────┘\n\n ┌────┬────┬────┬────┬────┬──"
   "──┬────┬────┬────┬────┬────┬────┬────┬─────────┐    ┌────┬────┬────┬─"
   "───┐\n │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ "
   "%s │ %s │ %s │ %s      │    │ %s │ %s │ %s │ %s │\n │ %s │ "
   "%s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s"
   " │ %s      │    │ %s │ %s │ %s │ %s │\n ├────┴──┬─┴──┬─┴──┬─┴──┬─"
   "┴──┬─┴──┬─┴──┬─┴──┬─┴──┬─┴──┬─┴──┬─┴──┬─┴──┬──────┤    ├────┼────┼───"
   "─┼────┤\n │ %s    │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ "
   "%s │ %s │ %s │ %s │ %s   │    │ %s │ %s │ %s │    │\n │ %s  "
   "  │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ "
   "%s │ %s   │    │ %s │ %s │ %s │ %s │\n ├───────┴┬───┴┬───┴┬───┴"
   "┬───┴┬───┴┬───┴┬───┴┬───┴┬───┴┬───┴┬───┴─┬──┴──────┤    ├────┼────┼──"
   "──┤    │\n │ %s     │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s "
   "│ %s │ %s │ %s  │ %s      │    │ %s │ %s │ %s │ %s │\n │ %s "
   "    │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s  │ "
   "%s      │    │ %s │ %s │ %s │    │\n ├────────┴──┬─┴──┬─┴──┬─┴──┬"
   "─┴──┬─┴──┬─┴──┬─┴──┬─┴──┬─┴──┬─┴──┬──┴────┬────┘    ├────┼────┼────┼─"
   "───┤\n │ %s        │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │"
   " %s │ %s │ %s    │  ┌────┐ │ %s │ %s │ %s │    │\n │ %s        "
   "│ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s │ %s    "
   "│  │ %s │ │ %s │ %s │ %s │ %s │\n ├──────┬────┴─┬──┴──┬─┴────┴──"
   "──┴────┴────┴────┴──┬─┴──┬─┴──┬─┴──┬────┘  │ %s │ └────┼────┼────┤  "
   "  │\n │ %s   │ %s   │ %s  │ %s                          │ %s │ %s"
   " │ %s │  ┌────┼────┼────┐ │ %s │ %s │ %s │\n │ %s   │ %s   │ %s"
   "  │ %s                          │ %s │ %s │ %s │  │ %s │ %s │ %s"
   " │ │ %s │ %s │    │\n └──────┴──────┴─────┴─────────────────────────"
   "────┴────┴────┴────┘  │ %s │ %s │ %s │ └────┴────┴────┘\n         "
   "                                                            └────┴───"
   "─┴────┘\n\n"))

(defconst +cdr255-keyboards:ansi100-base-layout+
  (list
   ;; Name
   "Base"
   ;; S-ESC
   "　"
   ;; S-F1
   "　"
   ;; S-F2
   "　"
   ;; S-F3
   "　"
   ;; S-F4
   "　"
   ;; S-F5
   "　"
   ;; S-F6
   "　"
   ;; S-F7
   "　"
   ;; S-F8
   "　"
   ;; S-F9
   "　"
   ;; S-F10
   "　"
   ;; S-F11
   "　"
   ;; S-F12
   "　"
   ;; S-F13
   "　"
   ;; S-F14
   "　"
   ;; S-LayerSwitch
   "　"
   ;; S-END
   "⭰"
   ;; S-Pgdn
   "⭻"
   ;; S-Delete
   "⎀ "
   ;; ESC
   "⎋"
   ;; F1
   "⑴"
   ;; F2
   "⑵"
   ;; F3
   "⑶"
   ;; F4
   "⑷"
   ;; F5
   "⑸"
   ;; F6
   "⑹"
   ;; F7
   "⑺"
   ;; F8
   "⑻"
   ;; F9
   "⑼"
   ;; F10
   "⑽"
   ;; F11
   "⑾"
   ;; F12
   "⑿"
   ;; F13
   "⒀"
   ;; F14
   "⒁"
   ;; LayerSwitch
   "ⓟ"
   ;; END
   "⭲"
   ;; Pgdn
   "⭽"
   ;; Delete
   "⌦ "
   ;; S-`
   "～"
   ;; S-1
   "！"
   ;; S-2
   "＠"
   ;; S-3
   "＃"
   ;; S-4
   "＄"
   ;; S-5
   "％"
   ;; S-6
   "＾"
   ;; S-7
   "＆"
   ;; S-8
   "＊"
   ;; S-9
   "（"
   ;; S-0
   "）"
   ;; S--
   "＿"
   ;; S-=
   "＋"
   ;; S-Backspace
   "⇫ "
   ;; S-Numlock
   "⇭ "
   ;; S-K/
   "　"
   ;; S-K*
   "　"
   ;; S-K-
   "　"
   ;; `
   "｀"
   ;; 1
   "１"
   ;; 2
   "２"
   ;; 3
   "３"
   ;; 4
   "４"
   ;; 5
   "５"
   ;; 6
   "６"
   ;; 7
   "７"
   ;; 8
   "８"
   ;; 9
   "９"
   ;; 0
   "０"
   ;; -
   "－"
   ;; =
   "＝"
   ;; Backspace
   "🠴"
   ;; Numlock
   "⎉"
   ;; K/
   "／"
   ;; K*
   "＊"
   ;; K-
   "－"
   ;; S-TAB
   "⥒"
   ;; S-q
   "Ｑ"
   ;; S-w
   "Ｗ"
   ;; S-e
   "Ｅ"
   ;; S-r
   "Ｒ"
   ;; S-t
   "Ｔ"
   ;; S-y
   "Ｙ"
   ;; S-u
   "Ｕ"
   ;; S-i
   "Ｉ"
   ;; S-o
   "Ｏ"
   ;; S-p
   "Ｐ"
   ;; S-[
   "｛"
   ;; S-]
   "｝"
   ;; S-\
   "｜"
   ;; S-K7
   "　"
   ;; S-K8
   "　"
   ;; S-K9
   "　"
   ;; TAB
   "⥗"
   ;; q
   "ｑ"
   ;; w
   "ｗ"
   ;; e
   "ｅ"
   ;; r
   "ｒ"
   ;; t
   "ｔ"
   ;; y
   "ｙ"
   ;; u
   "ｕ"
   ;; i
   "ｉ"
   ;; o
   "ｏ"
   ;; p
   "ｐ"
   ;; [
   "［"
   ;; ]
   "］"
   ;; \
   "＼"
   ;; K7
   "７"
   ;; K8
   "８"
   ;; K9
   "９"
   ;; S-K+
   "　"
   ;; S-C
   "　"
   ;; S-a
   "Ａ"
   ;; S-s
   "Ｓ"
   ;; S-d
   "Ｄ"
   ;; S-f
   "Ｆ"
   ;; S-g
   "Ｇ"
   ;; S-h
   "Ｈ"
   ;; S-j
   "Ｊ"
   ;; S-k
   "Ｋ"
   ;; S-l
   "Ｌ"
   ;; S-;
   "："
   ;; S-'
   "＂"
   ;; S-RET
   "　"
   ;; S-K4
   "　"
   ;; S-K5
   "　"
   ;; S-K6
   "　"
   ;; K+
   "＋"
   ;; C
   "⎈"
   ;; a
   "ａ"
   ;; s
   "ｓ"
   ;; d
   "ｄ"
   ;; f
   "ｆ"
   ;; g
   "ｇ"
   ;; h
   "ｈ"
   ;; j
   "ｊ"
   ;; k
   "ｋ"
   ;; l
   "ｌ"
   ;; ;
   "；"
   ;; '
   "＇"
   ;; RET
   "⮠"
   ;; K4
   "４"
   ;; K5
   "５"
   ;; K6
   "６"
   ;; S-S
   "　"
   ;; S-z
   "Ｚ"
   ;; S-x
   "Ｘ"
   ;; S-c
   "Ｃ"
   ;; S-v
   "Ｖ"
   ;; S-b
   "Ｂ"
   ;; S-n
   "Ｎ"
   ;; S-m
   "Ｍ"
   ;; S-,
   "＜"
   ;; S-.
   "＞"
   ;; S-/
   "？"
   ;; S-F18
   "　"
   ;; S-K1
   "　"
   ;; S-K2
   "　"
   ;; S-K3
   "　"
   ;; S
   "🡅"
   ;; z
   "ｚ"
   ;; x
   "ｘ"
   ;; c
   "ｃ"
   ;; v
   "ｖ"
   ;; b
   "ｂ"
   ;; n
   "ｎ"
   ;; m
   "ｍ"
   ;; ,
   "，"
   ;; .
   "．"
   ;; /
   "／"
   ;; F18
   "⒅"
   ;; S-UP
   "　"
   ;; K1
   "１"
   ;; K2
   "２"
   ;; K3
   "３"
   ;; S-KRET
   "　"
   ;; UP
   "⮉"
   ;; S-H
   "　"
   ;; S-s-
   "　"
   ;; S-M
   "　"
   ;; S-SPC
   "　"
   ;; S-F17
   "　"
   ;; S-Repeat
   "　"
   ;; S-FN
   "　"
   ;; S-K0
   "　"
   ;; S-K.
   "　"
   ;; KRET
   "⮠"
   ;; H
   "❖"
   ;; s-
   "⯁"
   ;; M
   "⎇"
   ;; SPC
   "␣ "
   ;; F17
   "⒄"
   ;; Repeat
   "⟲"
   ;; FN
   "🗝"
   ;; S-LEFT
   "　"
   ;; S-DOWN
   "　"
   ;; S-RIGHT
   "　"
   ;; K0
   "０"
   ;; K.
   "．"
   ;; LEFT
   "⮈"
   ;; DOWN
   "⮋"
   ;; RIGHT
   "⮊"
   ))

(defconst +cdr255-keyboards:ansi100-function-layout+
  (list
   ;; Name
   "Function"
   ;; S-ESC
   "⏻"
   ;; S-F1
   "🔆"
   ;; S-F2
   "🔅"
   ;; S-F3
   "🖽"
   ;; S-F4
   "☰"
   ;; S-F5
   "🖮"
   ;; S-F6
   "🖦"
   ;; S-F7
   "⏮"
   ;; S-F8
   "⏯"
   ;; S-F9
   "⏭"
   ;; S-F10
   "🔇"
   ;; S-F11
   "🔉"
   ;; S-F12
   "🔊"
   ;; S-F13
   "⎙"
   ;; S-F14
   "⎚"
   ;; S-LayerSwitch
   "　"
   ;; S-END
   "　"
   ;; S-Pgdn
   "　"
   ;; S-Delete
   "　"
   ;; ESC
   "　"
   ;; F1
   "　"
   ;; F2
   "　"
   ;; F3
   "　"
   ;; F4
   "　"
   ;; F5
   "　"
   ;; F6
   "　"
   ;; F7
   "　"
   ;; F8
   "　"
   ;; F9
   "　"
   ;; F10
   "　"
   ;; F11
   "　"
   ;; F12
   "　"
   ;; F13
   "　"
   ;; F14
   "　"
   ;; LayerSwitch
   "　"
   ;; END
   "　"
   ;; Pgdn
   "　"
   ;; Delete
   "　"
   ;; S-`
   "　"
   ;; S-1
   "　"
   ;; S-2
   "　"
   ;; S-3
   "　"
   ;; S-4
   "　"
   ;; S-5
   "　"
   ;; S-6
   "　"
   ;; S-7
   "　"
   ;; S-8
   "　"
   ;; S-9
   "　"
   ;; S-0
   "　"
   ;; S--
   "　"
   ;; S-=
   "　"
   ;; S-Backspace
   "　"
   ;; S-Numlock
   "　"
   ;; S-K/
   "　"
   ;; S-K*
   "　"
   ;; S-K-
   "　"
   ;; `
   "　"
   ;; 1
   "　"
   ;; 2
   "　"
   ;; 3
   "　"
   ;; 4
   "　"
   ;; 5
   "　"
   ;; 6
   "　"
   ;; 7
   "　"
   ;; 8
   "　"
   ;; 9
   "　"
   ;; 0
   "　"
   ;; -
   "　"
   ;; =
   "　"
   ;; Backspace
   "　"
   ;; Numlock
   "　"
   ;; K/
   "　"
   ;; K*
   "　"
   ;; K-
   "　"
   ;; S-TAB
   "　"
   ;; S-q
   "　"
   ;; S-w
   "　"
   ;; S-e
   "　"
   ;; S-r
   "　"
   ;; S-t
   "　"
   ;; S-y
   "　"
   ;; S-u
   "　"
   ;; S-i
   "　"
   ;; S-o
   "　"
   ;; S-p
   "　"
   ;; S-[
   "　"
   ;; S-]
   "　"
   ;; S-\
   "　"
   ;; S-K7
   "　"
   ;; S-K8
   "　"
   ;; S-K9
   "　"
   ;; TAB
   "　"
   ;; q
   "　"
   ;; w
   "　"
   ;; e
   "　"
   ;; r
   "　"
   ;; t
   "　"
   ;; y
   "　"
   ;; u
   "　"
   ;; i
   "　"
   ;; o
   "　"
   ;; p
   "　"
   ;; [
   "　"
   ;; ]
   "　"
   ;; \
   "　"
   ;; K7
   "　"
   ;; K8
   "　"
   ;; K9
   "　"
   ;; S-K+
   "　"
   ;; S-C
   "　"
   ;; S-a
   "　"
   ;; S-s
   "　"
   ;; S-d
   "　"
   ;; S-f
   "　"
   ;; S-g
   "　"
   ;; S-h
   "　"
   ;; S-j
   "　"
   ;; S-k
   "　"
   ;; S-l
   "　"
   ;; S-;
   "　"
   ;; S-'
   "　"
   ;; S-RET
   "　"
   ;; S-K4
   "　"
   ;; S-K5
   "　"
   ;; S-K6
   "　"
   ;; K+
   "　"
   ;; C
   "　"
   ;; a
   "　"
   ;; s
   "　"
   ;; d
   "　"
   ;; f
   "　"
   ;; g
   "　"
   ;; h
   "　"
   ;; j
   "　"
   ;; k
   "　"
   ;; l
   "　"
   ;; ;
   "　"
   ;; '
   "　"
   ;; RET
   "　"
   ;; K4
   "　"
   ;; K5
   "　"
   ;; K6
   "　"
   ;; S-S
   "　"
   ;; S-z
   "　"
   ;; S-x
   "　"
   ;; S-c
   "　"
   ;; S-v
   "　"
   ;; S-b
   "　"
   ;; S-n
   "　"
   ;; S-m
   "　"
   ;; S-,
   "　"
   ;; S-.
   "　"
   ;; S-/
   "　"
   ;; S-F18
   "　"
   ;; S-K1
   "　"
   ;; S-K2
   "　"
   ;; S-K3
   "　"
   ;; S
   "　"
   ;; z
   "　"
   ;; x
   "　"
   ;; c
   "　"
   ;; v
   "　"
   ;; b
   "　"
   ;; n
   "　"
   ;; m
   "　"
   ;; ,
   "　"
   ;; .
   "　"
   ;; /
   "　"
   ;; F18
   "　"
   ;; S-UP
   "　"
   ;; K1
   "　"
   ;; K2
   "　"
   ;; K3
   "　"
   ;; S-KRET
   "　"
   ;; UP
   "　"
   ;; S-H
   "　"
   ;; S-s-
   "　"
   ;; S-M
   "　"
   ;; S-SPC
   "　"
   ;; S-F17
   "　"
   ;; S-Repeat
   "　"
   ;; S-FN
   "　"
   ;; S-K0
   "　"
   ;; S-K.
   "　"
   ;; KRET
   "　"
   ;; H
   "　"
   ;; s-
   "　"
   ;; M
   "　"
   ;; SPC
   "　"
   ;; F17
   "　"
   ;; Repeat
   "　"
   ;; FN
   "　"
   ;; S-LEFT
   "　"
   ;; S-DOWN
   "　"
   ;; S-RIGHT
   "　"
   ;; K0
   "　"
   ;; K.
   "　"
   ;; LEFT
   "　"
   ;; DOWN
   "　"
   ;; RIGHT
   "　"
   ))


(defun cdr255-keyboards:display-keyboard-in-temp-buffer (format-string layout-list)
  
  (with-output-to-temp-buffer (make-temp-name (concat "cdr255-keyboard-" (car layout-list) "-"))
    (print
     (apply #'format
	    (append (list format-string) layout-list)))))

;; (cdr255-keyboards:display-keyboard-in-temp-buffer +cdr-keyboards:ansi100-layout-format-string+
;; 						  +cdr255-keyboards:ansi100-base-layout+)


(provide 'cdr255-keyboards)

;;; cdr255-keyboards.el ends here
